<?php

namespace App\Console\Commands;

use App\Jobs\SyncLeagueResultsJob;
use App\Jobs\SyncLeagueStandingsJob;
use App\Models\League;
use Illuminate\Console\Command;

class SyncAllLeaguesResultsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:sync-all-leagues-results {--season=2025}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync results and standings for all enabled leagues';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $leagues = League::where('is_enabled', true)->get();
        $season = $this->option('season');

        $dates = [
            now()->format('Y-m-d'),
            now()->subDay()->format('Y-m-d'),
        ];

        foreach ($leagues as $league) {
            // Sync Fixtures/Results
            foreach ($dates as $date) {
                SyncLeagueResultsJob::dispatch($league->api_league_id, $date);
            }

            // Sync Standings
            SyncLeagueStandingsJob::dispatch($league->api_league_id, $season);
        }

        $this->info("Sync jobs (results & standings) dispatched for all enabled leagues (Season: $season).");
    }
}
