<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ContactMessageResource\Pages;
use App\Models\ContactMessage;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ContactMessageResource extends Resource
{
    protected static ?string $model = ContactMessage::class;

    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-left-right';

    public static function getNavigationLabel(): string
    {
        return app()->getLocale() == 'ar' ? 'رسائل التواصل' : 'Contact Messages';
    }

    public static function getModelLabel(): string
    {
        return app()->getLocale() == 'ar' ? 'رسالة' : 'Message';
    }

    public static function getPluralModelLabel(): string
    {
        return app()->getLocale() == 'ar' ? 'رسائل' : 'Messages';
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\Select::make('user_id')
                            ->label(__('المستخدم'))
                            ->relationship('user', 'name')
                            ->searchable()
                            ->preload(),
                        Forms\Components\TextInput::make('subject')
                            ->label(__('الموضوع'))
                            ->required()
                            ->maxLength(255),
                        Forms\Components\Textarea::make('message')
                            ->label(__('الرسالة'))
                            ->required()
                            ->columnSpanFull(),
                        Forms\Components\Select::make('status')
                            ->label(__('الحالة'))
                            ->options([
                                'pending' => __('قيد الانتظار'),
                                'replied' => __('تم الرد'),
                                'closed' => __('مغلقة'),
                            ])
                            ->required()
                            ->default('pending'),
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.name')
                    ->label(__('المستخدم'))
                    ->sortable()
                    ->searchable(),
                Tables\Columns\TextColumn::make('subject')
                    ->label(__('الموضوع'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('status')
                    ->label(__('الحالة'))
                    ->badge()
                    ->colors([
                        'warning' => 'pending',
                        'success' => 'replied',
                        'danger' => 'closed',
                    ]),
                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('تاريخ الإرسال'))
                    ->dateTime()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContactMessages::route('/'),
            'create' => Pages\CreateContactMessage::route('/create'),
            'edit' => Pages\EditContactMessage::route('/{record}/edit'),
        ];
    }
}
