<?php

namespace App\Filament\Resources;

use App\Filament\Resources\FootballMatchResource\Pages;
use App\Models\FootballMatch;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class FootballMatchResource extends Resource
{
    protected static ?string $model = FootballMatch::class;

    protected static ?string $navigationIcon = 'heroicon-o-calendar';

    public static function getNavigationLabel(): string
    {
        return __('messages.matches');
    }

    public static function getModelLabel(): string
    {
        return __('messages.matches');
    }

    public static function getPluralModelLabel(): string
    {
        return __('messages.matches');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\TextInput::make('api_fixture_id')
                            ->label(__('معرف المباراة (API)'))
                            ->required()
                            ->numeric(),
                        Forms\Components\Select::make('league_id')
                            ->label(__('الدوري'))
                            ->relationship('league', 'name_ar')
                            ->searchable()
                            ->preload()
                            ->required(),
                        Forms\Components\DateTimePicker::make('match_date')
                            ->label(__('تاريخ المباراة'))
                            ->required(),
                        Forms\Components\TextInput::make('status')
                            ->label(__('الحالة'))
                            ->required(),
                        Forms\Components\TextInput::make('home_team_name_en')
                            ->label(__('صاحب الأرض (إنجليزي)'))
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('home_team_name_ar')
                            ->label(__('صاحب الأرض (عربي)'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\TextInput::make('away_team_name_en')
                            ->label(__('الضيف (إنجليزي)'))
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('away_team_name_ar')
                            ->label(__('الضيف (عربي)'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\TextInput::make('home_score')
                            ->label(__('أهداف صاحب الأرض'))
                            ->numeric()
                            ->default(null),
                        Forms\Components\TextInput::make('away_score')
                            ->label(__('أهداف الضيف'))
                            ->numeric()
                            ->default(null),
                        Forms\Components\TextInput::make('venue')
                            ->label(__('الملعب'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\TextInput::make('city')
                            ->label(__('المدينة'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\KeyValue::make('raw_json')
                            ->label(__('بيانات API الخام'))
                            ->columnSpanFull(),
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('match_date')
                    ->label(__('التاريخ'))
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('league.name_ar')
                    ->label(__('الدوري'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('home_team_name_ar')
                    ->label(__('صاحب الأرض'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('home_score')
                    ->label('-')
                    ->numeric(),
                Tables\Columns\TextColumn::make('away_score')
                    ->label('-')
                    ->numeric(),
                Tables\Columns\TextColumn::make('away_team_name_ar')
                    ->label(__('الضيف'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('status')
                    ->label(__('الحالة')),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFootballMatches::route('/'),
            'create' => Pages\CreateFootballMatch::route('/create'),
            'edit' => Pages\EditFootballMatch::route('/{record}/edit'),
        ];
    }
}
