<?php

namespace App\Filament\Resources;

use App\Filament\Resources\LeagueResource\Pages;
use App\Models\League;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class LeagueResource extends Resource
{
    protected static ?string $model = League::class;

    protected static ?string $navigationIcon = 'heroicon-o-trophy';

    public static function getNavigationLabel(): string
    {
        return __('messages.leagues');
    }

    public static function getModelLabel(): string
    {
        return __('messages.leagues');
    }

    public static function getPluralModelLabel(): string
    {
        return __('messages.leagues');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\TextInput::make('api_league_id')
                            ->label(__('معرف الدوري (API)'))
                            ->required()
                            ->numeric(),
                        Forms\Components\TextInput::make('name_en')
                            ->label(__('الاسم (إنجليزي)'))
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('name_ar')
                            ->label(__('الاسم (عربي)'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\TextInput::make('country')
                            ->label(__('الدولة'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\FileUpload::make('logo')
                            ->label(__('الشعار'))
                            ->image()
                            ->directory('leagues'),
                        Forms\Components\Toggle::make('is_enabled')
                            ->label(__('مفعل'))
                            ->required(),
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('logo')
                    ->label(__('الشعار'))
                    ->circular(),
                Tables\Columns\TextColumn::make('api_league_id')
                    ->label(__('معرف API'))
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('name_ar')
                    ->label(__('الاسم (عربي)'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('name_en')
                    ->label(__('الاسم (إنجليزي)'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('country')
                    ->label(__('الدولة'))
                    ->searchable(),
                Tables\Columns\IconColumn::make('is_enabled')
                    ->label(__('مفعل'))
                    ->boolean(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListLeagues::route('/'),
            'create' => Pages\CreateLeague::route('/create'),
            'edit' => Pages\EditLeague::route('/{record}/edit'),
        ];
    }
}
