<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TeamResource\Pages;
use App\Models\Team;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class TeamResource extends Resource
{
    protected static ?string $model = Team::class;

    protected static ?string $navigationIcon = 'heroicon-o-user-group';

    public static function getNavigationLabel(): string
    {
        return __('messages.teams');
    }

    public static function getModelLabel(): string
    {
        return __('messages.teams');
    }

    public static function getPluralModelLabel(): string
    {
        return __('messages.teams');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make()
                    ->schema([
                        Forms\Components\TextInput::make('api_team_id')
                            ->label(__('معرف الفريق (API)'))
                            ->numeric()
                            ->default(null),
                        Forms\Components\Select::make('league_id')
                            ->label(__('الدوري'))
                            ->relationship('league', 'name_ar')
                            ->searchable()
                            ->preload()
                            ->required(),
                        Forms\Components\TextInput::make('name_en')
                            ->label(__('الاسم (إنجليزي)'))
                            ->required()
                            ->maxLength(255),
                        Forms\Components\TextInput::make('name_ar')
                            ->label(__('الاسم (عربي)'))
                            ->maxLength(255)
                            ->default(null),
                        Forms\Components\FileUpload::make('logo')
                            ->label(__('الشعار'))
                            ->image()
                            ->directory('teams'),
                        Forms\Components\Textarea::make('description_en')
                            ->label(__('الوصف (إنجليزي)'))
                            ->columnSpanFull(),
                        Forms\Components\Textarea::make('description_ar')
                            ->label(__('الوصف (عربي)'))
                            ->columnSpanFull(),
                    ])->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\ImageColumn::make('logo')
                    ->label(__('الشعار'))
                    ->circular(),
                Tables\Columns\TextColumn::make('name_ar')
                    ->label(__('الاسم (عربي)'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('name_en')
                    ->label(__('الاسم (إنجليزي)'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('league.name_ar')
                    ->label(__('الدوري'))
                    ->sortable(),
                Tables\Columns\TextColumn::make('api_team_id')
                    ->label(__('معرف API'))
                    ->numeric()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTeams::route('/'),
            'create' => Pages\CreateTeam::route('/create'),
            'edit' => Pages\EditTeam::route('/{record}/edit'),
        ];
    }
}
