<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\ContactMessage;
use Illuminate\Http\Request;

class ContactController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
        ]);

        ContactMessage::create([
            'user_id' => $request->user()?->id,
            'subject' => $request->subject,
            'message' => $request->message,
            'status' => 'new',
        ]);

        return response()->json([
            'status' => 'success',
            'message' => 'Message sent successfully',
        ]);
    }
}
