<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\League;

class LeagueController extends Controller
{
    public function index()
    {
        $leagues = League::where('is_enabled', true)->get();

        return response()->json([
            'status' => 'success',
            'data' => $leagues,
        ]);
    }

    public function show($id)
    {
        $league = League::where('is_enabled', true)->findOrFail($id);

        return response()->json([
            'status' => 'success',
            'data' => $league,
        ]);
    }
}
