<?php

namespace App\Http\Controllers\Api\v1;

use App\Http\Controllers\Controller;
use App\Models\FootballMatch;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class ResultController extends Controller
{
    public function index(Request $request)
    {
        $leagueId = $request->input('league_id');
        $date = $request->input('date', now()->format('Y-m-d'));

        $cacheKey = "results:{$leagueId}:{$date}";

        $results = Cache::remember($cacheKey, now()->addHours(3), function () use ($leagueId, $date) {
            $query = FootballMatch::where('status', 'finished')
                ->whereDate('match_date', $date);

            if ($leagueId) {
                $query->where('league_id', $leagueId);
            }

            return $query->get();
        });

        return response()->json([
            'status' => 'success',
            'data' => $results,
        ]);
    }
}
