<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\NewsCategory;
use Illuminate\Http\Request;

class NewsController extends Controller
{
    public function index(Request $request)
    {
        $query = News::where('status', 'published')
            ->orderBy('is_pinned', 'desc')
            ->orderBy('published_at', 'desc');

        if ($request->has('category')) {
            $category = NewsCategory::where('slug', $request->category)->firstOrFail();
            $query->where('category_id', $category->id);
        }

        $news = $query->paginate(12);
        $categories = NewsCategory::withCount('news')->get();

        return view('news.index', compact('news', 'categories'));
    }

    public function show($slug)
    {
        $news = News::where('slug', $slug)
            ->where('status', 'published')
            ->firstOrFail();

        $relatedNews = News::where('category_id', $news->category_id)
            ->where('id', '!=', $news->id)
            ->where('status', 'published')
            ->take(3)
            ->get();

        return view('news.show', compact('news', 'relatedNews'));
    }
}
