<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class League extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $fillable = [
        'api_league_id',
        'name_en',
        'name_ar',
        'country',
        'logo',
        'standings_json',
        'is_enabled',
    ];

    protected $casts = [
        'standings_json' => 'array',
        'is_enabled' => 'boolean',
    ];

    public function teams()
    {
        return $this->hasMany(Team::class);
    }

    public function matches()
    {
        return $this->hasMany(FootballMatch::class);
    }
}
