<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\League;
use App\Services\FootballApiService;

$api = new FootballApiService;
$leagues = League::where('is_enabled', true)->get();

foreach ($leagues as $league) {
    echo "League: {$league->name_en} ({$league->api_league_id}) - Season 2025... ";
    $response = Http::withHeaders([
        'x-rapidapi-key' => config('services.football_api.key'),
        'x-rapidapi-host' => 'v3.football.api-sports.io',
    ])->get('https://v3.football.api-sports.io/standings', [
        'league' => $league->api_league_id,
        'season' => 2025,
    ]);

    $res = $response->json();
    if (! empty($res['errors'])) {
        echo 'ERROR: '.($res['errors']['plan'] ?? json_encode($res['errors']))."\n";
    } elseif (empty($res['response'])) {
        echo "EMPTY\n";
    } else {
        echo "SUCCESS (Found standings)\n";
    }
}
