<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\Http;

$apiKey = config('services.football_api.key');
$baseUrl = 'https://v3.football.api-sports.io';

$response = Http::withHeaders([
    'x-rapidapi-key' => $apiKey,
    'x-rapidapi-host' => 'v3.football.api-sports.io',
])->get("{$baseUrl}/leagues", ['id' => 39]);

echo "Seasons for League 39:\n";
$data = $response->json()['response'][0]['seasons'] ?? [];
foreach ($data as $s) {
    echo 'Season: '.$s['year'].' - Current: '.($s['current'] ? 'YES' : 'NO')."\n";
}
