<?php

require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\FootballApiService;

$api = new FootballApiService;
$leagues = [39, 140, 233, 307];
$seasons = [2024, 2025];

foreach ($leagues as $id) {
    echo "League ID: $id\n";
    foreach ($seasons as $season) {
        $data = $api->getStandings($id, $season);
        echo "  Season $season: ".(empty($data) ? 'No Data' : 'Data Found ('.count($data[0] ?? []).' teams)')."\n";
    }
}
