<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\FootballApiService;

$api = new FootballApiService;
$leaguesToCheck = [39, 140, 233, 307, 848];

foreach ($leaguesToCheck as $id) {
    echo "Checking Seasons for League ID: $id\n";
    $response = Http::withHeaders([
        'x-rapidapi-key' => config('services.football_api.key'),
        'x-rapidapi-host' => 'v3.football.api-sports.io',
    ])->get('https://v3.football.api-sports.io/leagues', ['id' => $id]);

    $data = $response->json()['response'][0] ?? null;
    if ($data) {
        $seasons = $data['seasons'];
        $lastSeasons = array_slice($seasons, -3);
        foreach ($lastSeasons as $s) {
            echo "Year: {$s['year']} | Start: {$s['start']} | End: {$s['end']} | Current: ".($s['current'] ? 'YES' : 'NO')."\n";
        }
    }
    echo "--------------------------\n";
}
