<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Services\FootballApiService;

$api = new FootballApiService;
$response = Http::withHeaders([
    'x-rapidapi-key' => config('services.football_api.key'),
    'x-rapidapi-host' => 'v3.football.api-sports.io',
])->get('https://v3.football.api-sports.io/standings', [
    'league' => 39,
    'season' => 2025,
]);

echo "Season 2025 PL Standings Raw Response:\n";
print_r($response->json());
