<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('matches', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('api_fixture_id')->unique();
            $table->foreignId('league_id')->constrained('leagues')->cascadeOnDelete();
            $table->dateTime('match_date');
            $table->enum('status', ['scheduled', 'live', 'finished', 'postponed', 'cancelled']);
            $table->string('home_team_name_en');
            $table->string('home_team_name_ar')->nullable();
            $table->string('away_team_name_en');
            $table->string('away_team_name_ar')->nullable();
            $table->integer('home_score')->nullable();
            $table->integer('away_score')->nullable();
            $table->string('venue')->nullable();
            $table->string('city')->nullable();
            $table->json('raw_json')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('matches');
    }
};
