<?php

namespace Database\Seeders;

use App\Models\League;
use Illuminate\Database\Seeder;

class LeagueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $leagues = [
            [
                'api_league_id' => 233,
                'name_en' => 'Egyptian Premier League',
                'name_ar' => 'الدوري المصري الممتاز',
                'country' => 'Egypt',
            ],
            [
                'api_league_id' => 307,
                'name_en' => 'Saudi Pro League',
                'name_ar' => 'الدوري السعودي للمحترفين',
                'country' => 'Saudi Arabia',
            ],
            [
                'api_league_id' => 39,
                'name_en' => 'Premier League',
                'name_ar' => 'الدوري الإنجليزي الممتاز',
                'country' => 'England',
            ],
            [
                'api_league_id' => 17,
                'name_en' => 'AFC Champions League',
                'name_ar' => 'دوري أبطال آسيا',
                'country' => 'Asia',
            ],
            [
                'api_league_id' => 12,
                'name_en' => 'CAF Champions League',
                'name_ar' => 'دوري أبطال أفريقيا',
                'country' => 'Africa',
            ],
            [
                'api_league_id' => 2,
                'name_en' => 'UEFA Champions League',
                'name_ar' => 'دوري أبطال أوروبا',
                'country' => 'Europe',
            ],
        ];

        foreach ($leagues as $league) {
            League::updateOrCreate(['api_league_id' => $league['api_league_id']], $league);
        }
    }
}
