<?php

namespace Database\Seeders;

use App\Models\Player;
use Illuminate\Database\Seeder;

class PlayerSeeder extends Seeder
{
    public function run(): void
    {
        $players = [
            [
                'name_en' => 'Mohamed Salah',
                'name_ar' => 'محمد صلاح',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/148455-1603120384.jpg',
                'description_en' => 'Egyptian professional footballer who plays as a forward for Premier League club Liverpool.',
                'description_ar' => 'لاعب كرة قدم مصري محترف يلعب كمهاجم لنادي ليفربول في الدوري الإنجليزي الممتاز.',
            ],
            [
                'name_en' => 'Mahmoud El Khatib',
                'name_ar' => 'محمود الخطيب',
                'position' => 'Forward',
                'photo' => 'https://upload.wikimedia.org/wikipedia/commons/thumb/6/6c/Mahmoud_El_Khatib.jpg/220px-Mahmoud_El_Khatib.jpg',
                'description_en' => 'Former Egyptian footballer and current president of Al Ahly SC.',
                'description_ar' => 'لاعب كرة قدم مصري سابق ورئيس النادي الأهلي الحالي.',
            ],
            [
                'name_en' => 'Erling Haaland',
                'name_ar' => 'ايرلينج هالاند',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/418560-1658411082.jpg',
                'description_en' => 'Norwegian professional footballer who plays as a striker for Premier League club Manchester City.',
                'description_ar' => 'لاعب كرة قدم نرويجي محترف يلعب كمهاجم لنادي مانشستر سيتي في الدوري الإنجليزي الممتاز.',
            ],
            [
                'name_en' => 'Mohamed Abou Trika',
                'name_ar' => 'محمد ابو تريكه',
                'position' => 'Attacking Midfielder',
                'photo' => 'https://upload.wikimedia.org/wikipedia/commons/thumb/c/ca/Mohamed_Aboutrika_2013.jpg/220px-Mohamed_Aboutrika_2013.jpg',
                'description_en' => 'Former Egyptian professional footballer who played as an attacking midfielder.',
                'description_ar' => 'لاعب كرة قدم مصري محترف سابق لعب كوسط مهاجم.',
            ],
            [
                'name_en' => 'Cristiano Ronaldo',
                'name_ar' => 'كريستيانو رونالدو',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/8198-1694609670.jpg',
                'description_en' => 'Portuguese professional footballer who plays as a forward for Saudi Pro League club Al Nassr.',
                'description_ar' => 'لاعب كرة قدم برتغالي محترف يلعب كمهاجم لنادي النصر في دوري المحترفين السعودي.',
            ],
            [
                'name_en' => 'Lionel Messi',
                'name_ar' => 'ليونيل ميسي',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/28003-1710080339.jpg',
                'description_en' => 'Argentine professional footballer who plays as a forward for Major League Soccer club Inter Miami.',
                'description_ar' => 'لاعب كرة قدم أرجنتيني محترف يلعب كمهاجم لنادي إنتر ميامي في الدوري الأمريكي لكرة القدم.',
            ],
            [
                'name_en' => 'Kylian Mbappé',
                'name_ar' => 'كيليان مبابي',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/342229-1682683695.jpg',
                'description_en' => 'French professional footballer who plays as a forward for Real Madrid.',
                'description_ar' => 'لاعب كرة قدم فرنسي محترف يلعب كمهاجم لنادي ريال مدريد.',
            ],
            [
                'name_en' => 'Karim Benzema',
                'name_ar' => 'كريم بنزيما',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/18922-1694609756.jpg',
                'description_en' => 'French professional footballer who plays as a striker for Saudi Pro League club Al-Ittihad.',
                'description_ar' => 'لاعب كرة قدم فرنسي محترف يلعب كمهاجم لنادي الاتحاد في دوري المحترفين السعودي.',
            ],
            [
                'name_en' => 'Kevin De Bruyne',
                'name_ar' => 'كيفين دي بروين',
                'position' => 'Midfielder',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/88755-1668501254.jpg',
                'description_en' => 'Belgian professional footballer who plays as a midfielder for Premier League club Manchester City.',
                'description_ar' => 'لاعب كرة قدم بلجيكي محترف يلعب كلاعب وسط لنادي مانشستر سيتي في الدوري الإنجليزي الممتاز.',
            ],
            [
                'name_en' => 'Vinícius Júnior',
                'name_ar' => 'فينيسيوس جونيور',
                'position' => 'Forward',
                'photo' => 'https://img.a.transfermarkt.technology/portrait/header/371998-1664871901.jpg',
                'description_en' => 'Brazilian professional footballer who plays as a winger for La Liga club Real Madrid.',
                'description_ar' => 'لاعب كرة قدم برازيلي محترف يلعب كجناح لنادي ريال مدريد في الدوري الإسباني.',
            ],
        ];

        foreach ($players as $playerData) {
            Player::updateOrCreate(
                ['name_en' => $playerData['name_en']],
                $playerData
            );
        }
    }
}
