<?php

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Player;
use Illuminate\Support\Facades\Storage;

$player = Player::first();
echo 'Player Name: '.$player->name_en."\n";
echo 'DB Photo Path: '.$player->photo."\n";
echo 'Storage URL: '.Storage::disk('public')->url($player->photo)."\n";
echo 'APP_URL: '.config('app.url')."\n";
echo 'Public Path: '.public_path('storage')."\n";
echo 'Storage Path: '.storage_path('app/public')."\n";
