import 'package:flutter/material.dart';
import '../models/news.dart';
import 'package:intl/intl.dart';

class NewsDetailScreen extends StatelessWidget {
  final News news;

  NewsDetailScreen({required this.news});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: CustomScrollView(
        slivers: [
          // Elegant Header with Image
          SliverAppBar(
            expandedHeight: 300,
            pinned: true,
            backgroundColor: Color(0xFF0F172A),
            flexibleSpace: FlexibleSpaceBar(
              background: Hero(
                tag: 'news-${news.id}',
                child: news.coverImage != null
                    ? Image.network(
                        'http://10.0.2.2/storage/${news.coverImage}',
                        fit: BoxFit.cover,
                      )
                    : Container(color: Colors.blueGrey),
              ),
            ),
          ),

          // Content
          SliverToBoxAdapter(
            child: Container(
              padding: EdgeInsets.all(24),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    news.publishedAt != null ? DateFormat('EEEE, d MMMM yyyy').format(news.publishedAt!) : '',
                    style: TextStyle(color: Colors.blueAccent, fontSize: 13, fontWeight: FontWeight.bold),
                  ),
                  SizedBox(height: 16),
                  Text(
                    news.titleAr,
                    style: TextStyle(
                      fontSize: 24, 
                      fontWeight: FontWeight.black, 
                      height: 1.5,
                      color: Colors.white,
                    ),
                  ),
                  Divider(height: 40, color: Colors.white10),
                  Text(
                    news.contentAr,
                    style: TextStyle(
                      fontSize: 16, 
                      height: 1.8, 
                      color: Colors.grey[300],
                    ),
                  ),
                  SizedBox(height: 50),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
