import 'dart:convert';
import 'package:http/http.dart' as http;
import '../models/news.dart';
import '../models/football_match.dart';

class ApiService {
  static const String baseUrl = 'http://10.0.2.2/api/v1'; // 10.0.2.2 is localhost for Android Emulator

  Future<List<News>> getNews() async {
    final response = await http.get(Uri.parse('$baseUrl/news'));
    if (response.statusCode == 200) {
      final List data = json.decode(response.body)['data']['data'];
      return data.map((json) => News.fromJson(json)).toList();
    }
    throw Exception('Failed to load news');
  }

  Future<List<FootballMatch>> getMatches() async {
    final response = await http.get(Uri.parse('$baseUrl/matches'));
    if (response.statusCode == 200) {
      final List data = json.decode(response.body)['data'];
      return data.map((json) => FootballMatch.fromJson(json)).toList();
    }
    throw Exception('Failed to load matches');
  }

  Future<List<FootballMatch>> getLiveMatches() async {
    final response = await http.get(Uri.parse('$baseUrl/matches/live'));
    if (response.statusCode == 200) {
      final List data = json.decode(response.body)['data'];
      return data.map((json) => FootballMatch.fromJson(json)).toList();
    }
    throw Exception('Failed to load live matches');
  }
}
