import 'package:shared_preferences/shared_preferences.dart';

class FavoriteService {
  static const String _key = 'favorite_matches';

  Future<void> toggleFavorite(int matchId) async {
    final prefs = await SharedPreferences.getInstance();
    List<String> favorites = prefs.getStringList(_key) ?? [];
    
    String idStr = matchId.toString();
    if (favorites.contains(idStr)) {
      favorites.remove(idStr);
    } else {
      favorites.add(idStr);
    }
    
    await prefs.setStringList(_key, favorites);
  }

  Future<bool> isFavorite(int matchId) async {
    final prefs = await SharedPreferences.getInstance();
    List<String> favorites = prefs.getStringList(_key) ?? [];
    return favorites.contains(matchId.toString());
  }

  Future<List<int>> getFavorites() async {
    final prefs = await SharedPreferences.getInstance();
    List<String> favorites = prefs.getStringList(_key) ?? [];
    return favorites.map((id) => int.parse(id)).toList();
  }
}
