@extends('layouts.app')

@section('title', __('messages.login'))

@section('content')
<div class="flex justify-center items-center min-h-[60vh]">
    <div class="bg-white/5 border border-white/10 p-8 rounded-3xl w-full max-w-md backdrop-blur-sm">
        <h2 class="text-3xl font-black mb-6 text-center">{{ __('messages.login') }}</h2>
        
        <form action="{{ route('login') }}" method="POST" class="space-y-4">
            @csrf
            <div>
                <label class="block text-sm font-bold mb-2 text-gray-400">{{ __('البريد الإلكتروني') }}</label>
                <input type="email" name="email" value="{{ old('email') }}" required class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-blue-500 focus:outline-none transition text-white">
                @error('email')
                    <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                @enderror
            </div>
            
            <div>
                <label class="block text-sm font-bold mb-2 text-gray-400">{{ __('كلمة المرور') }}</label>
                <input type="password" name="password" required class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-blue-500 focus:outline-none transition text-white">
                @error('password')
                    <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                @enderror
            </div>

            <div class="flex items-center justify-between text-sm">
                <label class="flex items-center gap-2 cursor-pointer">
                    <input type="checkbox" name="remember" class="rounded border-white/10 bg-white/5 text-blue-500">
                    <span class="text-gray-400">{{ __('تذكرني') }}</span>
                </label>
            </div>

            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-500 text-white font-black py-4 rounded-xl transition shadow-lg shadow-blue-500/20 mt-4">
                {{ __('messages.login') }}
            </button>
        </form>

        <p class="text-center mt-6 text-gray-400 text-sm">
            {{ __('ليس لديك حساب؟') }} 
            <a href="{{ route('register') }}" class="text-blue-500 hover:underline font-bold">{{ __('messages.register') }}</a>
        </p>
    </div>
</div>
@endsection
