@extends('layouts.app')

@section('title', ($league->{'name_'.app()->getLocale()} ?: $league->name_en) . ' - B-Sports')

@section('content')
<style>
    .glass-card { background: rgba(30, 41, 59, 0.7); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); }
    .hover-scale { transition: transform 0.3s ease; }
    .hover-scale:hover { transform: scale(1.05); }
</style>

<div class="max-w-7xl mx-auto py-8">
    <!-- Header -->
    <header class="flex flex-col md:flex-row justify-between items-center mb-12 gap-6">
        <div>
            <h1 class="text-4xl font-black bg-gradient-to-r from-blue-400 to-emerald-400 bg-clip-text text-transparent">
                {{ $league->{'name_'.app()->getLocale()} ?: $league->name_en }}
            </h1>
            <p class="text-slate-400 mt-2">{{ __('messages.explore_teams') }}</p>
        </div>
        <a href="{{ url('/') }}" class="flex items-center gap-2 px-6 py-3 bg-slate-800 hover:bg-slate-700 rounded-2xl transition border border-slate-700 shadow-xl">
            <i class="fas fa-home"></i>
            <span>{{ __('messages.home') }}</span>
        </a>
    </header>

    <!-- Teams Grid -->
    <section class="mb-16">
        <h2 class="text-2xl font-black mb-8 flex items-center gap-3">
            <i class="fas fa-users text-blue-500"></i>
            {{ __('messages.teams') }}
        </h2>
        @if($teams->count() > 0)
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
                @foreach($teams as $team)
                <div class="glass-card rounded-[2rem] p-8 text-center hover-scale shadow-2xl group">
                    <div class="bg-white/5 rounded-2xl p-6 mb-6 group-hover:bg-white/10 transition">
                        <img src="{{ Str::startsWith($team->logo, 'http') ? $team->logo : asset('storage/' . $team->logo) }}" 
                             alt="{{ $team->{'name_'.app()->getLocale()} ?: $team->name_en }}" 
                             class="h-28 mx-auto object-contain drop-shadow-2xl">
                    </div>
                    <h3 class="text-xl font-black mb-6">{{ $team->{'name_'.app()->getLocale()} ?: $team->name_en }}</h3>
                    <a href="{{ url('/team/' . $team->id) }}" class="inline-block w-full py-4 bg-blue-600 hover:bg-blue-500 rounded-xl font-black transition shadow-lg shadow-blue-600/20">
                        {{ __('messages.view_players') }}
                    </a>
                </div>
                @endforeach
            </div>
        @else
            <div class="bg-slate-800/20 rounded-3xl p-12 text-center border border-dashed border-slate-700">
                <p class="text-slate-500 font-bold">{{ __('messages.no_teams_found') }}</p>
            </div>
        @endif
    </section>

    <!-- Standings Table -->
    @if(!empty($league->standings_json))
    <section class="mb-16">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-2xl font-black flex items-center gap-3">
                <i class="fas fa-list-ol text-emerald-500"></i>
                {{ __('messages.standings_table') }}
            </h2>
            <span class="px-4 py-1.5 bg-emerald-500/10 text-emerald-400 rounded-full text-xs font-black border border-emerald-500/20">
                {{ __('messages.season') }}: {{ is_array($league->standings_json) ? ($league->standings_json[0][0]['group'] ?? '2025/26') : '2025/26' }}
            </span>
        </div>

        @php
            $allStandings = is_array($league->standings_json) ? $league->standings_json : [];
        @endphp

        @foreach($allStandings as $standings)
            @if(count($allStandings) > 1)
                <h3 class="text-xl font-bold mb-4 text-slate-300">{{ $standings[0]['group'] ?? 'Group' }}</h3>
            @endif
            <div class="bg-slate-900/40 border border-white/5 rounded-[2.5rem] overflow-hidden shadow-2xl backdrop-blur-md mb-8 last:mb-0">
                <div class="overflow-x-auto">
                    <table class="w-full text-center">
                        <thead>
                            <tr class="bg-white/5 text-slate-400 uppercase text-[10px] font-black tracking-widest border-b border-white/5">
                                <th class="px-6 py-5">#</th>
                                <th class="px-6 py-5 text-{{ app()->getLocale() == 'ar' ? 'right' : 'left' }}">{{ __('messages.team') }}</th>
                                <th class="px-4 py-5">PL</th>
                                <th class="px-4 py-5">W</th>
                                <th class="px-4 py-5">D</th>
                                <th class="px-4 py-5">L</th>
                                <th class="px-4 py-5">GD</th>
                                <th class="px-6 py-5 text-blue-400">{{ __('messages.points') }}</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @foreach($standings as $row)
                                <tr class="hover:bg-white/5 transition group">
                                    <td class="px-6 py-4">
                                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-lg {{ $row['rank'] <= 4 ? 'bg-blue-500/10 text-blue-400' : 'text-slate-500' }} font-black text-xs">
                                            {{ $row['rank'] }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex items-center gap-4 text-{{ app()->getLocale() == 'ar' ? 'right' : 'left' }}">
                                            <img src="{{ $row['team']['logo'] }}" class="h-8 w-8 object-contain">
                                            <span class="font-bold text-white group-hover:text-blue-400 transition">{{ $row['team']['name'] }}</span>
                                        </div>
                                    </td>
                                    <td class="px-4 py-4 text-slate-300 font-bold">{{ $row['all']['played'] }}</td>
                                    <td class="px-4 py-4 text-emerald-500/80 font-bold">{{ $row['all']['win'] }}</td>
                                    <td class="px-4 py-4 text-slate-500 font-bold">{{ $row['all']['draw'] }}</td>
                                    <td class="px-4 py-4 text-rose-500/80 font-bold">{{ $row['all']['lose'] }}</td>
                                    <td class="px-4 py-4 text-slate-400 text-xs">{{ $row['goalsDiff'] }}</td>
                                    <td class="px-6 py-4">
                                        <span class="text-lg font-black text-white">{{ $row['points'] }}</span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endforeach
    </section>
    @endif

    <!-- Recent Matches -->
    <section>
        <h2 class="text-2xl font-black mb-8 flex items-center gap-3">
            <i class="fas fa-history text-amber-500"></i>
            {{ __('messages.match_schedule') }}
        </h2>
        @if($matches->count() > 0)
            <div class="grid gap-4">
                @foreach($matches as $match)
                    <a href="{{ route('match.show', $match->id) }}" class="bg-slate-900/40 border border-white/5 p-6 rounded-3xl flex items-center justify-between hover:bg-slate-800/60 transition group">
                        <div class="flex items-center gap-6 flex-1">
                            <div class="text-center min-w-[100px]">
                                <span class="text-xs text-slate-500 font-bold block mb-1">{{ $match->match_date->format('d M') }}</span>
                                <span class="text-sm font-black {{ $match->status == 'FT' ? 'text-slate-500' : 'text-blue-400' }}">
                                    {{ $match->status == 'FT' ? __('messages.finished') : $match->match_date->format('H:i') }}
                                </span>
                            </div>
                            
                            <div class="flex items-center gap-4 flex-1 justify-end">
                                <span class="font-bold text-sm md:text-base">{{ $match->{'home_team_name_'.app()->getLocale()} ?: $match->home_team_name_en }}</span>
                                <img src="{{ Str::startsWith($match->home_team_logo, 'http') ? $match->home_team_logo : asset('storage/' . $match->home_team_logo) }}" class="h-8 w-8 object-contain">
                            </div>

                            <div class="bg-black/40 px-4 py-2 rounded-xl font-black text-lg min-w-[80px] text-center">
                                {{ $match->home_score }} - {{ $match->away_score }}
                            </div>

                            <div class="flex items-center gap-4 flex-1">
                                <img src="{{ Str::startsWith($match->away_team_logo, 'http') ? $match->away_team_logo : asset('storage/' . $match->away_team_logo) }}" class="h-8 w-8 object-contain">
                                <span class="font-bold text-sm md:text-base">{{ $match->{'away_team_name_'.app()->getLocale()} ?: $match->away_team_name_en }}</span>
                            </div>
                        </div>
                        <i class="fas fa-chevron-{{ app()->getLocale() == 'ar' ? 'left' : 'right' }} text-slate-700 group-hover:text-blue-500 transition ml-4 mr-4"></i>
                    </a>
                @endforeach
            </div>
        @else
            <div class="bg-slate-800/20 rounded-3xl p-12 text-center border border-dashed border-slate-700">
                <p class="text-slate-500 font-bold">{{ __('messages.no_matches_found') }}</p>
            </div>
        @endif
    </section>
</div>
@endsection
