@extends('layouts.app')

@section('title', __('messages.players'))

@section('content')
<div class="max-w-7xl mx-auto py-8">
    <div class="flex justify-between items-center mb-12">
        <h1 class="text-4xl font-black bg-gradient-to-r from-blue-400 to-emerald-400 bg-clip-text text-transparent">
            {{ __('messages.players') }}
        </h1>
    </div>

    <div class="bg-slate-900/40 border border-white/5 rounded-[2rem] overflow-hidden shadow-2xl backdrop-blur-md">
        <div class="overflow-x-auto">
            <table class="w-full text-right rtl:text-right ltr:text-left">
                <thead>
                    <tr class="bg-white/5 text-slate-400 uppercase text-[10px] font-black tracking-widest border-b border-white/5">
                        <th class="px-8 py-6">{{ __('messages.players') }}</th>
                        <th class="px-8 py-6">{{ __('messages.position') }}</th>
                        <th class="px-8 py-6">{{ __('messages.team') }}</th>
                        <th class="px-8 py-6 text-center">{{ __('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @foreach($players as $player)
                    <tr class="hover:bg-white/5 transition group">
                        <td class="px-8 py-4">
                            <div class="flex items-center gap-4">
                                <img src="{{ Str::startsWith($player->photo, 'http') ? $player->photo : asset('storage/' . $player->photo) }}" 
                                     class="h-12 w-12 rounded-2xl object-cover shadow-xl border border-white/10"
                                     onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                                <span class="font-bold text-white group-hover:text-blue-400 transition">{{ $player->{'name_'.app()->getLocale()} ?: $player->name_en }}</span>
                            </div>
                        </td>
                        <td class="px-8 py-4">
                            <span class="px-4 py-1.5 rounded-full text-[10px] font-black bg-blue-500/10 text-blue-400 border border-blue-500/20 uppercase">
                                {{ $player->position }}
                            </span>
                        </td>
                        <td class="px-8 py-4">
                            @if($player->team)
                            <div class="flex items-center gap-3">
                                <img src="{{ Str::startsWith($player->team->logo, 'http') ? $player->team->logo : asset('storage/' . $player->team->logo) }}" 
                                     class="h-6 w-6 object-contain">
                                <span class="text-sm font-bold text-slate-300">{{ $player->team->{'name_'.app()->getLocale()} ?: $player->team->name_en }}</span>
                            </div>
                            @else
                                <span class="text-slate-500 text-xs">N/A</span>
                            @endif
                        </td>
                        <td class="px-8 py-4 text-center">
                            <a href="{{ route('players.show', $player->id) }}" class="inline-flex items-center justify-center w-10 h-10 rounded-xl bg-slate-800 hover:bg-blue-600 text-white transition shadow-lg">
                                <i class="fas fa-eye text-sm"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="px-8 py-6 bg-black/20">
            {{ $players->links() }}
        </div>
    </div>
</div>
@endsection
