@extends('layouts.app')

@section('title', ($team->{'name_'.app()->getLocale()} ?: $team->name_en) . ' - ' . __('messages.players'))

@section('content')
<style>
    .player-card { background: linear-gradient(145deg, #1e293b, #0f172a); border: 1px solid rgba(255, 255, 255, 0.05); }
    .position-badge { background: rgba(59, 130, 246, 0.1); color: #60a5fa; border: 1px solid rgba(59, 130, 246, 0.2); }
</style>

<div class="max-w-7xl mx-auto py-8">
    <!-- Navigation Buttons -->
    <div class="flex justify-between items-center mb-12">
        <a href="{{ url('/league/' . $team->league_id) }}" class="flex items-center gap-2 px-6 py-3 bg-slate-800 hover:bg-slate-700 rounded-2xl transition border border-slate-700 shadow-xl">
            <i class="fas fa-chevron-{{ app()->getLocale() == 'ar' ? 'right' : 'left' }}"></i>
            <span>{{ __('messages.back_to_league') }}</span>
        </a>
        <a href="{{ url('/') }}" class="bg-slate-800 p-3 rounded-2xl hover:bg-slate-700 transition border border-slate-700 shadow-xl">
            <i class="fas fa-home text-blue-400"></i>
        </a>
    </div>

    <!-- Team Header -->
    <div class="flex flex-col md:flex-row items-center gap-8 mb-16 bg-slate-800/20 p-8 rounded-[3rem] border border-white/5">
        <div class="bg-white/5 p-6 rounded-[2rem]">
            <img src="{{ Str::startsWith($team->logo, 'http') ? $team->logo : asset('storage/' . $team->logo) }}" 
                 class="h-24 w-24 md:h-32 md:w-32 object-contain drop-shadow-2xl">
        </div>
        <div class="text-center md:text-right">
            <h1 class="text-4xl md:text-5xl font-black mb-4">{{ $team->{'name_'.app()->getLocale()} ?: $team->name_en }}</h1>
            <p class="text-slate-400 text-lg">{{ __('messages.squad_list') }}</p>
        </div>
    </div>

    <!-- Players Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 xl:grid-cols-5 gap-8">
        @foreach($players as $player)
        <a href="{{ route('players.show', $player->id) }}" class="player-card rounded-[2.5rem] overflow-hidden shadow-2xl hover:border-blue-500/50 transition duration-500 group block">
            <div class="relative h-64 bg-slate-800/50">
                <img src="{{ Str::startsWith($player->photo, 'http') ? $player->photo : asset('storage/' . $player->photo) }}" 
                     class="w-full h-full object-cover group-hover:scale-110 transition duration-700"
                     onerror="this.src='https://cdn-icons-png.flaticon.com/512/53/53254.png'">
                <div class="absolute inset-0 bg-gradient-to-t from-slate-950 to-transparent opacity-60"></div>
                <span class="absolute bottom-4 {{ app()->getLocale() == 'ar' ? 'right-4' : 'left-4' }} px-4 py-1.5 rounded-full text-xs font-black position-badge backdrop-blur-md">
                    {{ $player->position }}
                </span>
            </div>
            <div class="p-6 text-center">
                <h3 class="font-black text-lg truncate mb-2">{{ $player->{'name_'.app()->getLocale()} ?: $player->name_en }}</h3>
                <div class="flex justify-center gap-2">
                    <span class="text-[10px] font-bold text-slate-500 uppercase tracking-widest">ID: {{ $player->api_player_id }}</span>
                </div>
            </div>
        </a>
        @endforeach
    </div>
</div>
@endsection
