<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ScoreHub - @yield('title', 'Home')</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700;800;900&family=Inter:wght@400;700&display=swap');
        
        :root {
            --font-arabic: 'Tajawal', sans-serif;
            --font-english: 'Inter', sans-serif;
        }

        body { 
            font-family: {{ app()->getLocale() == 'ar' ? "var(--font-arabic)" : "var(--font-english)" }} !important; 
        }

        /* تأكيد تطبيق الخط على جميع العناصر */
        body, h1, h2, h3, h4, h5, h6, span, p, a, button, input {
            font-family: {{ app()->getLocale() == 'ar' ? "var(--font-arabic)" : "var(--font-english)" }} !important;
        }
    </style>
</head>
<body class="bg-[#020617] text-[#f8fafc]">
    <nav class="bg-black/40 backdrop-blur-md border-b border-white/5 text-white shadow-lg sticky top-0 z-50">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
            <a href="{{ route('home') }}" class="flex items-center gap-2">
                <img src="{{ asset('images/logo.png') }}" alt="ScoreHub Logo" class="h-12 w-auto">
            </a>
            <div class="flex items-center space-x-8 rtl:space-x-reverse">
                <div class="hidden md:flex space-x-6 rtl:space-x-reverse font-bold text-sm">
                    <a href="{{ route('home') }}" class="hover:text-blue-400 transition">{{ __('messages.home') }}</a>
                    <a href="{{ route('matches.index') }}" class="hover:text-blue-400 transition">{{ __('messages.matches') }}</a>
                    <a href="{{ route('standings.index') }}" class="hover:text-blue-400 transition">{{ __('messages.standings_table') }}</a>
                    <a href="{{ route('players.index') }}" class="hover:text-blue-400 transition">{{ __('messages.players') }}</a>
                    <a href="{{ route('home') }}#news" class="hover:text-blue-400 transition">{{ __('messages.news') }}</a>
                </div>
                
                <div class="flex items-center space-x-4 rtl:space-x-reverse">
                    <div class="flex items-center space-x-2 rtl:space-x-reverse border-l rtl:border-l-0 rtl:border-r border-white/10 pl-4 rtl:pl-0 rtl:pr-4">
                        @if(app()->getLocale() == 'en')
                            <a href="{{ route('lang.switch', 'ar') }}" class="text-xs hover:text-blue-400 font-black uppercase tracking-widest">AR</a>
                        @else
                            <a href="{{ route('lang.switch', 'en') }}" class="text-xs hover:text-blue-400 font-black uppercase tracking-widest">EN</a>
                        @endif
                    </div>

                    @auth
                        <div class="flex items-center gap-4">
                            <span class="text-sm font-bold text-gray-300">{{ Auth::user()->name }}</span>
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="text-xs text-gray-400 hover:text-red-500 transition font-bold uppercase tracking-widest">
                                    {{ __('messages.logout') }}
                                </button>
                            </form>
                        </div>
                    @else
                        <a href="{{ route('login') }}" class="bg-blue-600 hover:bg-blue-500 text-white px-5 py-2 rounded-xl text-sm font-black transition shadow-lg shadow-blue-500/20">{{ __('messages.login') }}</a>
                    @endauth
                </div>
            </div>
        </div>
    </nav>

    <main class="container mx-auto px-4 py-8">
        @yield('content')
    </main>

    <footer class="bg-[#0f172a] border-t border-white/5 pt-16 pb-8 mt-20">
        <div class="container mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-16">
                <!-- Brand Section -->
                <div class="col-span-1 md:col-span-1">
                    <img src="{{ asset('images/logo.png') }}" alt="ScoreHub Logo" class="h-12 w-auto mb-6">
                    <p class="text-gray-400 text-sm leading-relaxed">
                        {{ app()->getLocale() == 'ar' ? 'منصتك الشاملة لمتابعة أحدث أخبار كرة القدم، نتائج المباريات، وجداول الترتيب في أهم الدوريات العالمية والمحلية.' : 'Your comprehensive platform for the latest football news, match results, and standings in the most important global and local leagues.' }}
                    </p>
                </div>

                <!-- Quick Links -->
                <div>
                    <h4 class="text-white font-bold mb-6 text-lg">{{ __('messages.quick_links') ?? (app()->getLocale() == 'ar' ? 'روابط سريعة' : 'Quick Links') }}</h4>
                    <ul class="space-y-4 text-gray-400 text-sm">
                        <li><a href="{{ route('home') }}" class="hover:text-blue-400 transition">{{ __('messages.home') }}</a></li>
                        <li><a href="{{ route('matches.index') }}" class="hover:text-blue-400 transition">{{ __('messages.matches') }}</a></li>
                        <li><a href="{{ route('standings.index') }}" class="hover:text-blue-400 transition">{{ __('messages.standings_table') }}</a></li>
                        <li><a href="{{ route('news.index') }}" class="hover:text-blue-400 transition">{{ __('messages.news') }}</a></li>
                    </ul>
                </div>

                <!-- Contact & Support -->
                <div>
                    <h4 class="text-white font-bold mb-6 text-lg">{{ app()->getLocale() == 'ar' ? 'الدعم الفني' : 'Support' }}</h4>
                    <ul class="space-y-4 text-gray-400 text-sm">
                        <li>
                            <a href="https://support.tatbeeq.cloud" target="_blank" class="flex items-center gap-2 hover:text-blue-400 transition">
                                <i class="fas fa-headset text-blue-500"></i>
                                <span>{{ app()->getLocale() == 'ar' ? 'مركز المساعدة والدعم' : 'Help & Support Center' }}</span>
                            </a>
                        </li>
                        <li class="flex items-center gap-2">
                            <i class="fas fa-envelope text-blue-500"></i>
                            <span>support@tatbeeq.cloud</span>
                        </li>
                    </ul>
                </div>

                <!-- Social Media -->
                <div>
                    <h4 class="text-white font-bold mb-6 text-lg">{{ app()->getLocale() == 'ar' ? 'تابعنا' : 'Follow Us' }}</h4>
                    <div class="flex gap-4">
                        <a href="#" class="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center hover:bg-blue-600 transition text-gray-400 hover:text-white">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center hover:bg-blue-600 transition text-gray-400 hover:text-white">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center hover:bg-blue-600 transition text-gray-400 hover:text-white">
                            <i class="fab fa-instagram"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Bottom Section -->
            <div class="pt-8 border-t border-white/5 flex flex-col md:flex-row justify-between items-center gap-6">
                <p class="text-gray-500 text-xs">
                    &copy; {{ date('Y') }} ScoreHub. {{ __('messages.all_rights_reserved') }}.
                </p>
                
                <div class="flex items-center gap-2 text-sm">
                    <span class="text-gray-400">{{ app()->getLocale() == 'ar' ? 'تم الصنع بكل حب' : 'Made with love' }}</span>
                    <i class="fas fa-heart text-red-500 animate-pulse"></i>
                    <span class="text-gray-400">{{ app()->getLocale() == 'ar' ? 'إحدى مشاريع' : 'A project by' }}</span>
                    <a href="https://support.tatbeeq.cloud" target="_blank" class="text-blue-500 font-bold hover:text-blue-400 transition">تطبيق كلاود</a>
                </div>
            </div>
        </div>
    </footer>
</body>
</html>
