@extends('layouts.app')

@section('title', __('messages.news'))

@section('content')
<div class="max-w-7xl mx-auto">
    <header class="mb-12">
        <h1 class="text-4xl font-black mb-4">{{ __('messages.latest_news') }}</h1>
        <div class="flex gap-4 overflow-x-auto no-scrollbar pb-2">
            <a href="{{ route('news.index') }}" 
               class="px-6 py-2 rounded-xl font-bold transition text-sm whitespace-nowrap {{ !request('category') ? 'bg-blue-600 text-white' : 'bg-slate-800/40 text-slate-400 hover:bg-slate-700' }}">
                {{ __('messages.all') }}
            </a>
            @foreach($categories as $category)
                <a href="{{ route('news.index', ['category' => $category->slug]) }}" 
                   class="px-6 py-2 rounded-xl font-bold transition text-sm whitespace-nowrap {{ request('category') == $category->slug ? 'bg-blue-600 text-white' : 'bg-slate-800/40 text-slate-400 hover:bg-slate-700' }}">
                    {{ $category->{'name_'.app()->getLocale()} }} ({{ $category->news_count }})
                </a>
            @endforeach
        </div>
    </header>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
        @foreach($news as $item)
            <a href="{{ route('news.show', $item->slug) }}" class="bg-slate-900/40 border border-white/5 rounded-3xl overflow-hidden shadow-2xl hover:shadow-blue-500/10 transition group flex flex-col">
                <div class="relative overflow-hidden h-64">
                    <img src="{{ $item->image_url }}" 
                         class="w-full h-full object-cover group-hover:scale-105 transition duration-500"
                         alt="{{ $item->{'title_'.app()->getLocale()} }}">
                    @if($item->is_pinned)
                        <div class="absolute top-4 right-4 bg-blue-600 text-white text-[10px] font-black px-3 py-1 rounded-full uppercase tracking-widest shadow-lg">
                            <i class="fas fa-thumbtack mr-1"></i> {{ __('messages.pinned') }}
                        </div>
                    @endif
                </div>
                <div class="p-8 flex-1 flex flex-col">
                    <div class="text-[10px] text-blue-400 font-black uppercase tracking-widest mb-4">
                        {{ $item->category->{'name_'.app()->getLocale()} }}
                    </div>
                    <h2 class="font-bold text-2xl mb-4 leading-tight text-white group-hover:text-blue-400 transition">
                        {{ $item->{'title_'.app()->getLocale()} }}
                    </h2>
                    <p class="text-slate-400 text-sm line-clamp-3 mb-8 flex-1">
                        {{ Str::limit(strip_tags($item->{'content_'.app()->getLocale()}), 150) }}
                    </p>
                    <div class="flex justify-between items-center pt-6 border-t border-white/5">
                        <div class="text-slate-500 text-[10px] font-bold">
                            <i class="far fa-clock mr-1"></i> {{ $item->published_at ? $item->published_at->diffForHumans() : $item->created_at->diffForHumans() }}
                        </div>
                        <span class="text-blue-500 text-sm font-black group-hover:translate-x-2 transition duration-300">
                            {{ __('messages.read_more') }} <i class="fas fa-{{ app()->getLocale() == 'ar' ? 'arrow-left' : 'arrow-right' }} ml-1"></i>
                        </span>
                    </div>
                </div>
            </a>
        @endforeach
    </div>

    <div class="mt-12">
        {{ $news->links() }}
    </div>
</div>
@endsection
