<?php

use App\Http\Controllers\Api\v1\AuthController;
use App\Http\Controllers\Api\v1\ContactController;
use App\Http\Controllers\Api\v1\FavoriteController;
use App\Http\Controllers\Api\v1\LeagueController;
use App\Http\Controllers\Api\v1\MatchController;
use App\Http\Controllers\Api\v1\NewsController;
use App\Http\Controllers\Api\v1\PlayerController;
use App\Http\Controllers\Api\v1\ResultController;
use App\Http\Controllers\Api\v1\SettingController;
use App\Http\Controllers\Api\v1\TeamController;
use Illuminate\Support\Facades\Route;

Route::prefix('v1')->group(function () {
    // Auth
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);

    // Public Data
    Route::get('/leagues', [LeagueController::class, 'index']);
    Route::get('/leagues/{id}', [LeagueController::class, 'show']);

    Route::get('/matches', [MatchController::class, 'index']);
    Route::get('/matches/live', [MatchController::class, 'live']);
    Route::get('/matches/fixtures', [MatchController::class, 'fixtures']);
    Route::get('/matches/{id}', [MatchController::class, 'show']);

    Route::get('/results', [ResultController::class, 'index']);

    Route::get('/news', [NewsController::class, 'index']);
    Route::get('/news/categories', [NewsController::class, 'categories']);
    Route::get('/news/{slug}', [NewsController::class, 'show']);

    Route::get('/teams', [TeamController::class, 'index']);
    Route::get('/teams/{id}', [TeamController::class, 'show']);

    Route::get('/players', [PlayerController::class, 'index']);
    Route::get('/players/{id}', [PlayerController::class, 'show']);

    Route::get('/settings', [SettingController::class, 'index']);

    // Authenticated routes
    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/profile', [AuthController::class, 'profile']);
        Route::put('/profile', [AuthController::class, 'updateProfile']);
        Route::post('/logout', [AuthController::class, 'logout']);

        Route::get('/favorites', [FavoriteController::class, 'index']);
        Route::post('/favorites/toggle', [FavoriteController::class, 'toggle']);

        Route::post('/contact', [ContactController::class, 'store']);
    });
});
