<?php

use App\Models\Setting;
use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

$interval = Setting::where('key', 'sync_interval_hours')->first()?->value ?? 3;

// تحديث المباريات المباشرة كل 30 دقيقة
Schedule::command('football:fetch --live')->everyThirtyMinutes();

// تحديث مباريات اليوم والنتائج كل 30 دقيقة لضمان دقة البيانات
Schedule::command('football:fetch --fixtures')->everyThirtyMinutes();

// مزامنة الترتيب والنتائج لجميع الدوريات المفعّلة كل ساعة (بدلاً من 3 ساعات)
Schedule::command('app:sync-all-leagues-results --season=2025')->hourly();
