<?php

use App\Http\Controllers\FootballController;
use App\Http\Controllers\Web\AuthController;
use App\Http\Controllers\Web\HomeController;
use App\Http\Controllers\Web\LanguageController;
use App\Http\Controllers\Web\NewsController;
use Illuminate\Support\Facades\Route;

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('lang/{locale}', [LanguageController::class, 'switch'])->name('lang.switch');

// Auth Routes
Route::middleware('guest')->group(function () {
    Route::get('register', [AuthController::class, 'showRegister'])->name('register');
    Route::post('register', [AuthController::class, 'register']);
    Route::get('login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('login', [AuthController::class, 'login']);
});

Route::post('logout', [AuthController::class, 'logout'])->name('logout')->middleware('auth');

Route::get('/league/{league}', [FootballController::class, 'showLeague']);
Route::get('/team/{team}', [FootballController::class, 'showTeam']);
Route::get('/match/{match}', [FootballController::class, 'showMatch'])->name('match.show');
Route::get('/matches', [FootballController::class, 'matches'])->name('matches.index');
Route::get('/players', [FootballController::class, 'players'])->name('players.index');
Route::get('/player/{player}', [FootballController::class, 'showPlayer'])->name('players.show');
Route::get('/standings', [FootballController::class, 'standings'])->name('standings.index');

// News Routes
Route::get('/news', [NewsController::class, 'index'])->name('news.index');
Route::get('/news/{slug}', [NewsController::class, 'show'])->name('news.show');
