<?php $__env->startSection('title', __('messages.standings_table')); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto py-8">
    <div class="flex flex-col md:flex-row justify-between items-center mb-12 gap-6">
        <div>
            <h1 class="text-4xl font-black bg-gradient-to-r from-blue-400 to-emerald-400 bg-clip-text text-transparent">
                <?php echo e(__('messages.standings_table')); ?>

            </h1>
            <p class="text-slate-400 mt-2"><?php echo e(__('messages.follow_standings_desc')); ?></p>
        </div>
    </div>

    <div x-data="{ activeLeague: <?php echo e($leagues->first()->api_league_id ?? 0); ?> }">
        <!-- League Tabs -->
        <div class="flex flex-wrap gap-4 mb-10">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $leagues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $league): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button @click="activeLeague = <?php echo e($league->api_league_id); ?>" 
                        :class="activeLeague === <?php echo e($league->api_league_id); ?> ? 'bg-blue-600 text-white shadow-lg shadow-blue-600/20' : 'bg-slate-800 text-slate-400 hover:bg-slate-700'"
                        class="px-6 py-3 rounded-2xl font-bold transition duration-300">
                    <?php echo e($league->{'name_'.app()->getLocale()} ?: $league->name_en); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <!-- Standings Content -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $leagues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $league): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div x-show="activeLeague === <?php echo e($league->api_league_id); ?>" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-95" x-transition:enter-end="opacity-100 transform scale-100">
                <div class="flex justify-end mb-4">
                    <span class="px-4 py-1.5 bg-blue-500/10 text-blue-400 rounded-full text-xs font-black border border-blue-500/20">
                        <?php echo e(__('messages.season')); ?>: <?php echo e(is_array($league->standings_json) ? ($league->standings_json[0][0]['group'] ?? '2025/26') : '2025/26'); ?>

                    </span>
                </div>

                <?php
                    $allStandings = is_array($league->standings_json) ? $league->standings_json : [];
                ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $allStandings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $standings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($allStandings) > 1): ?>
                        <h3 class="text-xl font-bold mb-4 text-slate-300"><?php echo e($standings[0]['group'] ?? 'Group'); ?></h3>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <div class="bg-slate-900/40 border border-white/5 rounded-[2.5rem] overflow-hidden shadow-2xl backdrop-blur-md mb-8 last:mb-0">
                        <div class="overflow-x-auto">
                            <table class="w-full text-center">
                                <thead>
                                    <tr class="bg-white/5 text-slate-400 uppercase text-[10px] font-black tracking-widest border-b border-white/5">
                                        <th class="px-6 py-5">#</th>
                                        <th class="px-6 py-5 text-<?php echo e(app()->getLocale() == 'ar' ? 'right' : 'left'); ?>"><?php echo e(__('messages.team')); ?></th>
                                        <th class="px-4 py-5">PL</th>
                                        <th class="px-4 py-5">W</th>
                                        <th class="px-4 py-5">D</th>
                                        <th class="px-4 py-5">L</th>
                                        <th class="px-4 py-5">GD</th>
                                        <th class="px-6 py-5 text-blue-400"><?php echo e(__('messages.points')); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-white/5">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $standings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-white/5 transition group">
                                            <td class="px-6 py-4">
                                                <span class="inline-flex items-center justify-center w-8 h-8 rounded-lg <?php echo e($row['rank'] <= 4 ? 'bg-blue-500/10 text-blue-400' : 'text-slate-500'); ?> font-black text-xs">
                                                    <?php echo e($row['rank']); ?>

                                                </span>
                                            </td>
                                            <td class="px-6 py-4">
                                                <div class="flex items-center gap-4 text-<?php echo e(app()->getLocale() == 'ar' ? 'right' : 'left'); ?>">
                                                    <img src="<?php echo e($row['team']['logo']); ?>" class="h-8 w-8 object-contain">
                                                    <span class="font-bold text-white group-hover:text-blue-400 transition"><?php echo e($row['team']['name']); ?></span>
                                                </div>
                                            </td>
                                            <td class="px-4 py-4 text-slate-300 font-bold"><?php echo e($row['all']['played']); ?></td>
                                            <td class="px-4 py-4 text-emerald-500/80 font-bold"><?php echo e($row['all']['win']); ?></td>
                                            <td class="px-4 py-4 text-slate-500 font-bold"><?php echo e($row['all']['draw']); ?></td>
                                            <td class="px-4 py-4 text-rose-500/80 font-bold"><?php echo e($row['all']['lose']); ?></td>
                                            <td class="px-4 py-4 text-slate-400 text-xs"><?php echo e($row['goalsDiff']); ?></td>
                                            <td class="px-6 py-4">
                                                <span class="text-lg font-black text-white"><?php echo e($row['points']); ?></span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="bg-slate-900/40 border border-white/5 rounded-[2.5rem] p-12 text-center">
                        <p class="text-slate-500 font-bold"><?php echo e(__('messages.no_standings_data')); ?></p>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bsports\resources\views/football/standings.blade.php ENDPATH**/ ?>